// Background service worker - gestisce le chiamate API
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
    if (request.action === 'fetchETV') {
        fetchETV(request.serverUrl, request.domains, request.location, request.language)
            .then(sendResponse);
        return true; // keep channel open for async response
    }
    if (request.action === 'fetchGMB') {
        fetchGMB(request.serverUrl, request.domains, request.geo)
            .then(sendResponse);
        return true;
    }
});

async function fetchETV(serverUrl, domains, location, language) {
    try {
        const body = { domains };
        if (location) body.location_code = parseInt(location);
        if (language) body.language_code = language;

        const response = await fetch(serverUrl + '/api/etv', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(body)
        });
        const data = await response.json();
        return data.success ? data.results : {};
    } catch (e) {
        console.error('ETV error:', e);
        return {};
    }
}

async function fetchGMB(serverUrl, domains, geo) {
    try {
        const response = await fetch(serverUrl + '/api/gmb-claude', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ domains, geo })
        });
        const data = await response.json();
        return data.success ? data.results : {};
    } catch (e) {
        console.error('GMB error:', e);
        return {};
    }
}
