const DEFAULTS = {
    serverUrl: 'http://72.61.85.207:3847',
    etvEnabled: true,
    etvLocation: '',
    gmbEnabled: true,
    gmbProvider: 'serper',
    gmbGeo: 'it',
    gmbUseMaps: false
};

const PROVIDER_INFO = {
    serper: '<strong>Serper.dev:</strong> ~$0.003/dominio, veloce, affidabile',
    dataforseo: '<strong>DataForSEO:</strong> ~$0.002/dominio, più dati ma più lento'
};

function loadSettings() {
    chrome.storage.sync.get(DEFAULTS, (cfg) => {
        document.getElementById('serverUrl').value = cfg.serverUrl;
        document.getElementById('etvEnabled').checked = cfg.etvEnabled;
        document.getElementById('etvLocation').value = cfg.etvLocation;
        document.getElementById('gmbEnabled').checked = cfg.gmbEnabled;
        document.getElementById('gmbProvider').value = cfg.gmbProvider;
        document.getElementById('gmbGeo').value = cfg.gmbGeo;
        document.getElementById('gmbUseMaps').checked = cfg.gmbUseMaps;
        updateProviderInfo(cfg.gmbProvider);
    });
}

function getConfig() {
    return {
        serverUrl: document.getElementById('serverUrl').value.trim() || DEFAULTS.serverUrl,
        etvEnabled: document.getElementById('etvEnabled').checked,
        etvLocation: document.getElementById('etvLocation').value,
        gmbEnabled: document.getElementById('gmbEnabled').checked,
        gmbProvider: document.getElementById('gmbProvider').value,
        gmbGeo: document.getElementById('gmbGeo').value,
        gmbUseMaps: document.getElementById('gmbUseMaps').checked
    };
}

function updateProviderInfo(provider) {
    document.getElementById('providerInfo').innerHTML = PROVIDER_INFO[provider] || '';
}

function showStatus(msg, type, duration = 4000) {
    const el = document.getElementById('status');
    el.textContent = msg;
    el.className = 'show ' + type;
    if (duration > 0) {
        setTimeout(() => { el.className = ''; }, duration);
    }
}

async function saveSettings() {
    await chrome.storage.sync.set(getConfig());
    showStatus('Salvato!', 'ok');
}

async function startCalcola() {
    const btn = document.getElementById('btn-calcola');
    btn.disabled = true;
    btn.textContent = 'Avvio...';

    // Salva config prima di iniettare
    const cfg = getConfig();
    await chrome.storage.sync.set(cfg);

    try {
        const [tab] = await chrome.tabs.query({ active: true, currentWindow: true });

        if (!tab || !tab.url || !tab.url.includes('expireddomains.net')) {
            showStatus('Apri expireddomains.net prima!', 'err');
            btn.disabled = false;
            btn.textContent = 'CALCOLA ETV + GMB';
            return;
        }

        // Inietta content.js
        await chrome.scripting.executeScript({
            target: { tabId: tab.id },
            files: ['content.js']
        });

        showStatus('Calcolo avviato! Guarda la pagina.', 'ok');

    } catch (err) {
        showStatus('Errore: ' + err.message, 'err');
        console.error(err);
    }

    btn.disabled = false;
    btn.textContent = 'CALCOLA ETV + GMB';
}

document.addEventListener('DOMContentLoaded', function() {
    loadSettings();

    document.getElementById('btn-calcola').addEventListener('click', startCalcola);
    document.getElementById('btn-save').addEventListener('click', saveSettings);

    // Update provider info on change
    document.getElementById('gmbProvider').addEventListener('change', function() {
        updateProviderInfo(this.value);
    });
});
