// Content script v3.2 - Con filtro recensioni e Evidenziatore
(function() {
    chrome.storage.sync.get({
        serverUrl: 'http://72.61.85.207:3847',
        etvEnabled: true,
        etvLocation: '',
        gmbEnabled: true,
        gmbProvider: 'serper',
        gmbGeo: 'it',
        gmbUseMaps: false,
        highlightEnabled: false,
        highlightMinEtv: '',
        highlightGbp: '',
        highlightColor: '#90EE90'
    }, function(CONFIG) {
        runCalculation(CONFIG);
    });

    function runCalculation(CONFIG) {
        console.log('[EDC] Avvio v3.2 con config:', CONFIG);

        // Storage per risultati (usato dall'evidenziatore)
        var resultsETV = {};
        var resultsGMB = {};

        if (window.edcRunning) {
            showAlert('Calcolo già in corso!', 'warn');
            return;
        }
        window.edcRunning = true;

        // CSS
        if (!document.getElementById('edc-style')) {
            var style = document.createElement('style');
            style.id = 'edc-style';
            style.textContent = `
                .edc-hdr{background:#2c3e50!important;color:#fff!important;text-align:center!important;padding:5px 10px!important;font-weight:bold!important}
                .edc-cell{text-align:center!important;font-family:monospace!important;font-size:12px!important}
                .edc-hi{color:#27ae60;font-weight:bold}
                .edc-md{color:#f39c12;font-weight:bold}
                .edc-lo{color:#999}
                .edc-yes{background:#27ae60;color:#fff;padding:2px 6px;border-radius:3px;font-weight:bold;font-size:11px}
                .edc-no{background:#e74c3c;color:#fff;padding:2px 6px;border-radius:3px;font-weight:bold;font-size:11px}
                .edc-load{color:#3498db}
                .edc-bar{position:fixed;top:10px;left:50%;transform:translateX(-50%);background:#667eea;color:#fff;padding:12px 25px;border-radius:8px;z-index:99999;font-family:Arial,sans-serif;font-size:14px;box-shadow:0 4px 15px rgba(0,0,0,.3)}
                .edc-alert{position:fixed;top:60px;left:50%;transform:translateX(-50%);padding:15px 25px;border-radius:8px;z-index:99998;font-family:Arial,sans-serif;font-size:13px;box-shadow:0 4px 15px rgba(0,0,0,.3);max-width:400px;text-align:center}
                .edc-alert-error{background:#e74c3c;color:#fff}
                .edc-alert-warn{background:#f39c12;color:#fff}
                .edc-alert-info{background:#3498db;color:#fff}
                .edc-alert-close{position:absolute;top:5px;right:10px;cursor:pointer;font-size:18px;opacity:0.8}
                .edc-alert-close:hover{opacity:1}
                .edc-highlight{transition:background-color 0.3s ease}
            `;
            document.head.appendChild(style);
        }

        // Alert function
        function showAlert(message, type, duration = 0) {
            // Remove existing alerts
            var existingAlert = document.getElementById('edc-alert');
            if (existingAlert) existingAlert.remove();

            var alert = document.createElement('div');
            alert.id = 'edc-alert';
            alert.className = 'edc-alert edc-alert-' + type;
            alert.innerHTML = message + '<span class="edc-alert-close" onclick="this.parentElement.remove()">×</span>';
            document.body.appendChild(alert);

            if (duration > 0) {
                setTimeout(function() { alert.remove(); }, duration);
            }
        }

        // Error type to user message
        function getErrorMessage(errorType, errorMessage) {
            var messages = {
                'SERPER_AUTH_ERROR': '⚠️ API Key Serper non valida! Controlla la configurazione.',
                'SERPER_CREDITS_ERROR': '💰 Crediti Serper esauriti! Ricarica su serper.dev',
                'SERPER_RATE_LIMIT': '⏳ Troppe richieste Serper! Attendi qualche secondo.',
                'DATAFORSEO_AUTH_ERROR': '⚠️ Credenziali DataForSEO non valide!',
                'DATAFORSEO_CREDITS_ERROR': '💰 Crediti DataForSEO esauriti! Ricarica il conto.',
                'NETWORK_ERROR': '🌐 Impossibile contattare il server. È online?',
                'ETV_ERROR': '📊 Errore nel recupero dati ETV.',
                'GMB_ERROR': '📍 Errore nel check GMB.'
            };
            return messages[errorType] || errorMessage || 'Errore sconosciuto';
        }

        // Progress bar
        var bar = document.getElementById('edc-bar');
        if (bar) bar.remove();
        bar = document.createElement('div');
        bar.id = 'edc-bar';
        bar.className = 'edc-bar';
        bar.textContent = 'Cerco domini...';
        document.body.appendChild(bar);

        // Trova tabella
        var table = document.querySelector('table.base1');
        if (!table) {
            bar.textContent = 'ERRORE: Tabella non trovata!';
            window.edcRunning = false;
            setTimeout(function() { bar.remove(); }, 3000);
            return;
        }

        // Trova domini
        var domains = [];
        var domainMap = {};
        var rows = table.querySelectorAll('tbody tr');
        for (var i = 0; i < rows.length; i++) {
            var row = rows[i];
            var cell = row.querySelector('td.field_domain');
            if (!cell) continue;
            var link = cell.querySelector('a');
            if (!link) continue;
            var domain = link.getAttribute('title') || link.textContent.trim();
            if (domain && domain.indexOf('.') !== -1) {
                var item = { domain: domain, row: row, cell: cell };
                domains.push(item);
                domainMap[domain.toLowerCase()] = item;
            }
        }

        if (domains.length === 0) {
            bar.textContent = 'ERRORE: Nessun dominio trovato!';
            window.edcRunning = false;
            setTimeout(function() { bar.remove(); }, 3000);
            return;
        }

        bar.textContent = 'Trovati ' + domains.length + ' domini. Elaboro...';

        // Aggiungi header
        var hdrRow = table.querySelector('thead tr');
        if (hdrRow) {
            var oldHdrs = hdrRow.querySelectorAll('.edc-hdr');
            for (var h = 0; h < oldHdrs.length; h++) oldHdrs[h].remove();

            var domHdr = hdrRow.querySelector('th.head_domain');
            if (domHdr) {
                if (CONFIG.etvEnabled) {
                    var th1 = document.createElement('th');
                    th1.className = 'edc-hdr';
                    th1.textContent = 'ETV';
                    domHdr.after(th1);
                }
                if (CONFIG.gmbEnabled) {
                    var th2 = document.createElement('th');
                    th2.className = 'edc-hdr';
                    th2.textContent = 'GMB';
                    th2.title = 'Provider: ' + CONFIG.gmbProvider;
                    var afterEl = hdrRow.querySelector('.edc-hdr') || domHdr;
                    afterEl.after(th2);
                }
            }
        }

        // Aggiungi celle
        for (var j = 0; j < domains.length; j++) {
            var d = domains[j];
            var oldCells = d.row.querySelectorAll('.edc-cell');
            for (var c = 0; c < oldCells.length; c++) oldCells[c].remove();

            if (CONFIG.etvEnabled) {
                var td1 = document.createElement('td');
                td1.className = 'edc-cell edc-etv';
                td1.innerHTML = '<span class="edc-load">...</span>';
                d.cell.after(td1);
            }
            if (CONFIG.gmbEnabled) {
                var td2 = document.createElement('td');
                td2.className = 'edc-cell edc-gmb';
                td2.innerHTML = '<span class="edc-load">...</span>';
                var afterCell = d.row.querySelector('.edc-etv') || d.cell;
                afterCell.after(td2);
            }
        }

        // Helper
        function formatETV(v) {
            if (!v) return '0';
            if (v >= 1000000) return (v / 1000000).toFixed(1) + 'M';
            if (v >= 1000) return (v / 1000).toFixed(1) + 'K';
            return String(v);
        }

        function updateETV(domain, data) {
            var item = domainMap[domain.toLowerCase()];
            if (!item) return;
            var cell = item.row.querySelector('.edc-etv');
            if (!cell) return;

            // Salva risultato per evidenziatore
            var etvValue = (data && data.etv !== undefined) ? data.etv : 0;
            resultsETV[domain.toLowerCase()] = etvValue;

            if (data && data.etv !== undefined) {
                var v = data.etv;
                var cls = v >= 10000 ? 'edc-hi' : (v >= 1000 ? 'edc-md' : 'edc-lo');
                cell.innerHTML = '<span class="' + cls + '" title="ETV: ' + v + '">' + formatETV(v) + '</span>';
            } else {
                cell.innerHTML = '<span class="edc-lo">0</span>';
            }
        }

        function updateGMB(domain, data) {
            var item = domainMap[domain.toLowerCase()];
            if (!item) return;
            var cell = item.row.querySelector('.edc-gmb');
            if (!cell) return;

            // Salva risultato per evidenziatore (true/false/null)
            if (data && data.hasGMB === true) {
                resultsGMB[domain.toLowerCase()] = true;
            } else if (data && data.hasGMB === false) {
                resultsGMB[domain.toLowerCase()] = false;
            } else {
                resultsGMB[domain.toLowerCase()] = null;
            }

            if (data && data.hasGMB === true) {
                var title = data.businessName ? data.businessName : 'GMB trovato';
                if (data.rating) title += ' (' + data.rating + '★';
                if (data.ratingCount) title += ', ' + data.ratingCount + ' recensioni)';
                else if (data.rating) title += ')';
                if (data.address) title += '\n' + data.address;
                cell.innerHTML = '<span class="edc-yes" title="' + title.replace(/"/g, "'") + '">SI</span>';
            } else if (data && data.hasGMB === false) {
                cell.innerHTML = '<span class="edc-no" title="Nessun GMB trovato">NO</span>';
            } else if (data && data.error) {
                cell.innerHTML = '<span class="edc-lo" title="Errore: ' + data.error + '">?</span>';
            } else {
                cell.innerHTML = '<span class="edc-lo">?</span>';
            }
        }

        // Funzione evidenziatore
        function applyHighlighting() {
            if (!CONFIG.highlightEnabled) return;

            var minEtv = CONFIG.highlightMinEtv ? parseInt(CONFIG.highlightMinEtv, 10) : 0;
            var gbpFilter = CONFIG.highlightGbp; // '', 'yes', 'no'
            var color = CONFIG.highlightColor || '#90EE90';
            var highlighted = 0;

            console.log('[EDC] Evidenziatore attivo - Min ETV:', minEtv, 'GBP:', gbpFilter, 'Colore:', color);

            for (var i = 0; i < domains.length; i++) {
                var d = domains[i];
                var domainLower = d.domain.toLowerCase();
                var etv = resultsETV[domainLower] || 0;
                var gmb = resultsGMB[domainLower]; // true, false, null

                var matchEtv = true;
                var matchGbp = true;

                // Controllo ETV
                if (minEtv > 0) {
                    matchEtv = etv >= minEtv;
                }

                // Controllo GBP
                if (gbpFilter === 'yes') {
                    matchGbp = gmb === true;
                } else if (gbpFilter === 'no') {
                    matchGbp = gmb === false;
                }
                // Se gbpFilter è vuoto, matchGbp rimane true

                // Applica evidenziazione se entrambi i criteri sono soddisfatti
                if (matchEtv && matchGbp) {
                    d.row.classList.add('edc-highlight');
                    d.row.style.backgroundColor = color;
                    highlighted++;
                } else {
                    d.row.classList.remove('edc-highlight');
                    d.row.style.backgroundColor = '';
                }
            }

            console.log('[EDC] Evidenziati ' + highlighted + ' domini su ' + domains.length);
            if (highlighted > 0) {
                showAlert('Evidenziati ' + highlighted + ' domini che corrispondono ai criteri', 'info', 4000);
            }
        }

        var etvDone = !CONFIG.etvEnabled;
        var gmbDone = !CONFIG.gmbEnabled;
        var etvError = null;
        var gmbError = null;

        function updateProgress() {
            var parts = [];
            if (CONFIG.etvEnabled) {
                if (etvError) {
                    parts.push('ETV: ERRORE');
                } else {
                    parts.push('ETV: ' + (etvDone ? '✓' : '...'));
                }
            }
            if (CONFIG.gmbEnabled) {
                if (gmbError) {
                    parts.push('GMB: ERRORE');
                } else {
                    parts.push('GMB: ' + (gmbDone ? '✓' : '...'));
                }
            }
            bar.textContent = parts.join(' | ');

            if (etvDone && gmbDone) {
                if (etvError || gmbError) {
                    bar.style.background = '#e74c3c';
                    bar.textContent = 'Completato con errori';
                } else {
                    bar.textContent = '✓ Completato! ' + domains.length + ' domini.';
                    // Applica evidenziazione dopo il completamento
                    applyHighlighting();
                }
                window.edcRunning = false;
                setTimeout(function() { bar.remove(); }, 5000);
            }
        }

        // ETV: Una singola richiesta bulk
        if (CONFIG.etvEnabled) {
            var allDomains = domains.map(function(x) { return x.domain; });

            chrome.runtime.sendMessage({
                action: 'fetchETV',
                serverUrl: CONFIG.serverUrl,
                domains: allDomains,
                location: CONFIG.etvLocation
            }, function(response) {
                // Check for errors
                if (response && response.error) {
                    etvError = response;
                    showAlert(getErrorMessage(response.errorType, response.errorMessage), 'error');
                    // Mark all as error
                    for (var k = 0; k < domains.length; k++) {
                        var cell = domains[k].row.querySelector('.edc-etv');
                        if (cell) cell.innerHTML = '<span class="edc-lo" title="Errore">ERR</span>';
                    }
                } else {
                    var results = response || {};
                    for (var dom in results) {
                        updateETV(dom, results[dom]);
                    }
                    // Update missing
                    for (var k = 0; k < domains.length; k++) {
                        if (!results[domains[k].domain.toLowerCase()]) {
                            updateETV(domains[k].domain, null);
                        }
                    }
                }
                etvDone = true;
                updateProgress();
            });
        }

        // GMB: Una singola richiesta con provider selezionato
        if (CONFIG.gmbEnabled) {
            var allGmbDomains = domains.map(function(x) { return x.domain; });

            chrome.runtime.sendMessage({
                action: 'fetchGMB',
                serverUrl: CONFIG.serverUrl,
                domains: allGmbDomains,
                geo: CONFIG.gmbGeo,
                provider: CONFIG.gmbProvider,
                useMaps: CONFIG.gmbUseMaps
            }, function(response) {
                // Check for errors
                if (response && response.error) {
                    gmbError = response;
                    showAlert(getErrorMessage(response.errorType, response.errorMessage), 'error');
                    // Mark all as error
                    for (var k = 0; k < domains.length; k++) {
                        var cell = domains[k].row.querySelector('.edc-gmb');
                        if (cell) cell.innerHTML = '<span class="edc-lo" title="Errore">ERR</span>';
                    }
                } else {
                    var results = response.results || response || {};
                    for (var dom in results) {
                        updateGMB(dom, results[dom]);
                    }
                    // Show stats if available
                    if (response.stats) {
                        console.log('[EDC] GMB Stats:', response.stats);
                        if (response.stats.credits_used) {
                            console.log('[EDC] Crediti Serper usati:', response.stats.credits_used);
                        }
                    }
                }
                gmbDone = true;
                updateProgress();
            });
        }

        updateProgress();
    }
})();
